using System;
using System.Data;
using System.IO;
using System.Collections.Generic;
using System.Text;

namespace TableXml
{
   class Program
   {
      static DataTable dt;
      static void Main(string[] args)
      {
         dt = new DataTable("Customers");
         if (File.Exists("Customers.xml"))
         {
            dt.ReadXml("Customers.xml");
            Console.WriteLine("Znaleziono klientw: {0}", dt.Rows.Count);
            foreach (DataRow row in dt.Rows)
            {
               Console.WriteLine("[{0}] {1} {2}", row["CustomerID"],
                 row["FirstName"], row["LastName"]);
            }
         }
         else
            CreateCustomers();

         Console.Write("Nowy klient: ");
         string custName = Console.ReadLine();
         if (custName == string.Empty) return;
         string[] cust = custName.Split(' ');
         dt.Rows.Add(new object[] { dt.Rows.Count + 1, cust[0], cust[1] });
         dt.WriteXml("Customers.xml", XmlWriteMode.WriteSchema);
         Console.ReadLine();
      }

      public static void CreateCustomers()
      {
         dt.Columns.Add("CustomerID", typeof(int));
         dt.Columns.Add("FirstName", typeof(string));
         dt.Columns.Add("LastName", typeof(string));
         dt.Rows.Add(new object[] { 1, "Joanna", "Kowalska" });
         dt.Rows.Add(new object[] { 2, "Jan", "Kowalski" });
      }
   }
}
